### Before you can run these examples, you will need to download and install...
#...the packages below. These also require the installation of Tool Chain ++
# See this webpage for installation instructions: 
# https://github.com/rmcelreath/rethinking#installation 
library(StanHeaders)
library(cmdstanr)
library(rstan)
library(ggplot2)
library(rethinking)

# Open the dataset provided. Make sure you change the path to match the one in your machine.
d <- read.csv("D:/Teaching/Bayes Reg/data_birthweight.csv")
head(d)
summary(d)

#Create a graph of the density of observed values of maternal weight. 
dens(d$mw, main="Maternal Weight (Kg)")
#Add a line corresponding to the mean maternal weight, 72.01 Kg.
abline(v=72.01, col="lightgray")


### Initial prior ####

#Set a seed to ensure the example is replicated
set.seed(6354348)
#Create a random distribution of 10k cases assuming a normal distribution with...
#...mean 3300 g 
sample_mu<-rnorm(1e4, 3300, 2000)
# Now create a random distribution of the SD assuming a uniform distribution ...
#...with lower and upper bounds 0 and 1000 g, respectively
sample_sigma<-runif(1e4, 0, 1000)
# Now create a random distribution of 10k cases assuming the sample means are ...
#...the values estimated before and the SD those estimated before
prior_m1<-rnorm(1e4, sample_mu, sample_sigma)
#This can be plotted using the command "dens" from package "rethinking"
dens(prior_m1, xlab="Newborn's Birth Weight (g)" , lwd=4, col="brown3")
#However, another option is to calculate the density of the distribution...
dm1<-density(prior_m1)
#...and the plot it using the "plot" options
plot(dm1, lwd=3, col="brown3", ylab="Density", xlab="Newborn's Birth Weight (g)")
#...which allows to colour the density area:
polygon(dm1, col="brown2")
#add a vertical line to indicate point 0 on the x axis. 
abline(v=0, lty=5)
summary(prior_m1)
#Report the quantile of the prior to get an idea about the mass of credible ...
#...intervals according to this prior
quantile(prior_m1, 0.05)


### Second prior ####

#Set seed again if you want to replicate the example
set.seed(6354348)
#Create random samples of parameter Mu (Mean) and Sigma (SD), assuming...
#...Mu is normally disributed around mean 3300 g and SD 600 g...
#...and SD is uniformily distributed between 0 and 1000 g.
sample_mu<-rnorm(1e4, 3300, 600)
sample_sigma<-runif(1e4, 0, 1000)
#Create random samples using means and sigma from the previous random distributions
prior_m1<-rnorm(1e4, sample_mu, sample_sigma)
#Calculate density and plot it 
dm1<-density(prior_m1)
plot(dm1, lwd=3, col="brown3", ylab="Density", xlab="Newborn's Birth Weight (g)")
polygon(dm1, col="brown2")
abline(v=0, lty=5)
summary(prior_m1)
quantile(prior_m1, 0.05)


#### Prior with slope ####
# Set seed
set.seed(42563)
#create 100 cases "N"
N<-100
#Now assign random intercepts and slopes to these 100 cases using the assumptions...
#...below, e.g. the slope "b" is randomly distributed around mean 0 and SD 50.
a<-rnorm(N, 3300, 600 )
b<-rnorm(N, 0, 50)
#Create an empty plot where the x axis ranges from 35 and 120-->these are the values ...
#...of maternal weight over which the slopes will be produced...
#...the limits of the y axis are -100 to 6500
plot(NULL, xlim=c(35,120), ylim=c(-100,6500), xlab="Maternal Weight", ylab="Newborn's Birth Weight")
#Add an horizontal line at point 0, representing birthweight=0
abline (h=0, lty=2)
#anotehr line represents the threshold of low birth weight, 2500 g
abline(h=2500, lty=1, lwd=0.5)
#add a title
mtext("b ~ dnorm(0,50)")
#create a constant for the average maternal weight
xbar<-72.01
#the function below creates and plots lines using the function a+b(x-xbar)...
#assuming the values of x are from 35 to 120. 
for (i in 1:N) curve(a[i] + b[i]*(x-xbar), from=35, to=120, add=TRUE, col=col.alpha("brown3",0.2), lwd=3)


#### Prior with slope #2 ####
#It follows the same steps as before, the only difference is in the SD of the slope "b":
set.seed(42563)
N<-100
a<-rnorm(N, 3300, 600 )
b<-rnorm(N, 0, 25)
plot(NULL, xlim=c(35,120), ylim=c(-100,6500), xlab="Maternal Weight (Kg)", ylab="Newborn's Birth Weight (g)")
abline (h=0, lty=2)
abline(h=2500, lty=1, lwd=0.5)
mtext("b ~ dnorm(0,25)")
for (i in 1:N) curve(a[i] + b[i]*(x-xbar), from=35, to=120, add=TRUE, col=col.alpha("brown3",0.2), lwd=3)
